<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%booking}}`.
 */
class m260125_115403_create_booking_table extends Migration
{
    public function safeUp()
    {
        $this->createTable('{{%booking}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'room_type_id' => $this->integer()->notNull(),
            'check_in_date' => $this->date()->notNull(),
            'check_out_date' => $this->date()->notNull(),
            'adults_count' => $this->integer()->notNull(),
            'children_count' => $this->integer()->defaultValue(0),
            'total_price' => $this->decimal(10, 2)->notNull(),
            'payment_method' => $this->string(20)->notNull(), // cash, card
            'status' => $this->string(20)->defaultValue('new'), // new, processing, confirmed, cancelled, completed
            'special_requests' => $this->text(),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-booking-user_id',
            '{{%booking}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-booking-room_type_id',
            '{{%booking}}',
            'room_type_id',
            '{{%room_type}}',
            'id',
            'CASCADE'
        );

        // Добавляем индекс для поиска по датам
        $this->createIndex('idx-booking-dates', '{{%booking}}', ['check_in_date', 'check_out_date']);
        $this->createIndex('idx-booking-status', '{{%booking}}', ['status']);
    }

    public function safeDown()
    {
        $this->dropForeignKey('fk-booking-user_id', '{{%booking}}');
        $this->dropForeignKey('fk-booking-room_type_id', '{{%booking}}');
        $this->dropTable('{{%booking}}');
    }
}