<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%booking_service}}`.
 */
class m260125_115426_create_booking_service_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%booking_service}}', [
            'id' => $this->primaryKey(),
            'booking_id' => $this->integer()->notNull(),
            'service_name' => $this->string(100)->notNull(),
            'service_description' => $this->text(),
            'price' => $this->decimal(10, 2)->defaultValue(0),
            'created_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-booking_service-booking_id',
            '{{%booking_service}}',
            'booking_id',
            '{{%booking}}',
            'id',
            'CASCADE'
             );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%booking_service}}');
    }
}
