<?php

use yii\db\Migration;

/**
 * Handles the creation of table `{{%review}}`.
 */
class m260125_115447_create_review_table extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->createTable('{{%review}}', [
            'id' => $this->primaryKey(),
            'user_id' => $this->integer()->notNull(),
            'booking_id' => $this->integer()->notNull(),
            'rating' => $this->integer()->notNull()->check('rating >= 1 AND rating <= 5'),
            'comment' => $this->text()->notNull(),
            'created_at' => $this->integer()->notNull(),
            'updated_at' => $this->integer()->notNull(),
        ]);

        $this->addForeignKey(
            'fk-review-user_id',
            '{{%review}}',
            'user_id',
            '{{%user}}',
            'id',
            'CASCADE'
        );

        $this->addForeignKey(
            'fk-review-booking_id',
            '{{%review}}',
            'booking_id',
            '{{%booking}}',
            'id',
            'CASCADE'
        );
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropForeignKey('fk-review-user_id', '{{%review}}');
        $this->dropForeignKey('fk-review-booking_id', '{{%review}}');
        $this->dropTable('{{%review}}');
    }
}