<?php

/* @var $model app\models\Booking */

use yii\helpers\Html;
use yii\helpers\Url;

?>
<div class="booking-item-card">
    <div class="booking-header">
        <div class="booking-info">
            <h3 class="booking-id">Бронирование #<?= $model->id ?></h3>
            <div class="booking-meta">
                <span class="booking-user">
                    <?= Html::encode($model->user->full_name) ?> (<?= Html::encode($model->user->email) ?>)
                </span>
                <span class="booking-date">
                    <?= date('d.m.Y H:i', $model->created_at) ?>
                </span>
            </div>
        </div>
        
        <div class="booking-status">
            <span class="status-badge status-<?= $model->status ?>">
                <?= $model->statusLabel ?>
            </span>
        </div>
    </div>
    
    <div class="booking-details">
        <div class="detail-row">
            <div class="detail-column">
                <h4>Информация о номере</h4>
                <p><strong>Тип номера:</strong> <?= Html::encode($model->roomType->name) ?></p>
                <p><strong>Даты:</strong> <?= date('d.m.Y', strtotime($model->check_in_date)) ?> - <?= date('d.m.Y', strtotime($model->check_out_date)) ?></p>
                <p><strong>Ночей:</strong> <?= $model->nightsCount ?></p>
            </div>
            
            <div class="detail-column">
                <h4>Информация о гостях</h4>
                <p><strong>Гостей:</strong> <?= $model->adults_count ?> взрослых, <?= $model->children_count ?> детей</p>
                <p><strong>Способ оплаты:</strong> <?= $model->paymentMethodLabel ?></p>
                <p><strong>Стоимость:</strong> <?= $model->formattedTotalPrice ?></p>
            </div>
        </div>
        
        <?php if ($model->special_requests): ?>
            <div class="special-requests">
                <h4>Особые пожелания:</h4>
                <p><?= nl2br(Html::encode($model->special_requests)) ?></p>
            </div>
        <?php endif; ?>
        
        <?php if ($model->services): ?>
            <div class="services-list">
                <h4>Дополнительные услуги:</h4>
                <?php foreach ($model->services as $service): ?>
                    <div class="service-item">
                        <strong><?= Html::encode($service->service_name) ?>:</strong>
                        <?= nl2br(Html::encode($service->service_description)) ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    
    <div class="booking-actions">
        <div class="status-actions">
            <span>Изменить статус:</span>
            <div class="status-buttons">
                <a href="<?= Url::to(['update-status', 'id' => $model->id, 'status' => 'processing']) ?>" 
                   class="btn btn-small <?= $model->status == 'processing' ? 'btn-warning' : 'btn-outline-warning' ?>"
                   title="В процессе">
                    ⏳
                </a>
                <a href="<?= Url::to(['update-status', 'id' => $model->id, 'status' => 'confirmed']) ?>" 
                   class="btn btn-small <?= $model->status == 'confirmed' ? 'btn-success' : 'btn-outline-success' ?>"
                   title="Подтверждено">
                    ✅
                </a>
                <a href="<?= Url::to(['update-status', 'id' => $model->id, 'status' => 'cancelled']) ?>" 
                   class="btn btn-small <?= $model->status == 'cancelled' ? 'btn-danger' : 'btn-outline-danger' ?>"
                   title="Отменено">
                    ❌
                </a>
                <a href="<?= Url::to(['update-status', 'id' => $model->id, 'status' => 'completed']) ?>" 
                   class="btn btn-small <?= $model->status == 'completed' ? 'btn-info' : 'btn-outline-info' ?>"
                   title="Завершено">
                    📋
                </a>
            </div>
        </div>
        
        <div class="action-buttons">
            <a href="<?= Url::to(['view-booking', 'id' => $model->id]) ?>" class="btn btn-small">
                Подробнее
            </a>
        </div>
    </div>
</div>

<style>
.booking-item-card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    padding: 1.5rem;
    margin-bottom: 1.5rem;
    transition: transform 0.3s;
}

.booking-item-card:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.booking-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #eee;
}

.booking-id {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-size: 1.2rem;
}

.booking-meta {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.booking-user {
    color: #555;
    font-size: 0.9rem;
}

.booking-date {
    color: #95a5a6;
    font-size: 0.85rem;
}

.status-badge {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
}

.status-new {
    background: #3498db;
    color: white;
}

.status-processing {
    background: #f39c12;
    color: white;
}

.status-confirmed {
    background: #27ae60;
    color: white;
}

.status-cancelled {
    background: #e74c3c;
    color: white;
}

.status-completed {
    background: #7f8c8d;
    color: white;
}

.booking-details {
    margin-bottom: 1.5rem;
}

.detail-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
    margin-bottom: 1.5rem;
}

@media (max-width: 768px) {
    .detail-row {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
}

.detail-column h4 {
    color: #2c3e50;
    margin-bottom: 0.75rem;
    font-size: 1rem;
}

.detail-column p {
    margin-bottom: 0.5rem;
    color: #555;
}

.special-requests,
.services-list {
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 4px;
    margin-bottom: 1rem;
    border-left: 4px solid #3498db;
}

.special-requests h4,
.services-list h4 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.service-item {
    margin-bottom: 0.5rem;
    padding: 0.5rem;
    background: white;
    border-radius: 4px;
}

.booking-actions {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding-top: 1rem;
    border-top: 1px solid #eee;
}

.status-actions {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.status-buttons {
    display: flex;
    gap: 0.25rem;
}

.btn-small {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
}

.btn-outline-warning {
    background: transparent;
    color: #f39c12;
    border: 1px solid #f39c12;
}

.btn-warning {
    background: #f39c12;
    color: white;
    border: 1px solid #f39c12;
}

.btn-outline-success {
    background: transparent;
    color: #27ae60;
    border: 1px solid #27ae60;
}

.btn-success {
    background: #27ae60;
    color: white;
    border: 1px solid #27ae60;
}

.btn-outline-danger {
    background: transparent;
    color: #e74c3c;
    border: 1px solid #e74c3c;
}

.btn-danger {
    background: #e74c3c;
    color: white;
    border: 1px solid #e74c3c;
}

.btn-outline-info {
    background: transparent;
    color: #3498db;
    border: 1px solid #3498db;
}

.btn-info {
    background: #3498db;
    color: white;
    border: 1px solid #3498db;
}
</style>