<?php

/* @var $model app\models\User */

use yii\helpers\Html;
use yii\helpers\Url;

$bookingCount = $model->getBookings()->count();
$reviewCount = $model->getReviews()->count();
?>
<div class="user-item-card">
    <div class="user-header">
        <div class="user-avatar">
            <span class="avatar-placeholder">👤</span>
        </div>
        
        <div class="user-info">
            <h3 class="user-name"><?= Html::encode($model->full_name) ?></h3>
            <div class="user-meta">
                <span class="user-email"><?= Html::encode($model->email) ?></span>
                <span class="user-login">@<?= Html::encode($model->username) ?></span>
            </div>
        </div>
        
        <?php if ($model->username === 'hotel'): ?>
            <span class="admin-badge">Администратор</span>
        <?php endif; ?>
    </div>
    
    <div class="user-details">
        <div class="detail-row">
            <div class="detail-column">
                <h4>Контактная информация</h4>
                <p><strong>Телефон:</strong> <?= Html::encode($model->phone) ?></p>
                <p><strong>Адрес:</strong> <?= Html::encode($model->address) ?></p>
            </div>
            
            <div class="detail-column">
                <h4>Паспортные данные</h4>
                <p><strong>Паспорт:</strong> <?= Html::encode($model->passport_series) ?> <?= Html::encode($model->passport_number) ?></p>
                <p><strong>Дата регистрации:</strong> <?= date('d.m.Y', $model->created_at) ?></p>
            </div>
        </div>
        
        <div class="user-stats">
            <div class="stat">
                <span class="stat-label">Бронирований</span>
                <span class="stat-value"><?= $bookingCount ?></span>
            </div>
            
            <div class="stat">
                <span class="stat-label">Отзывов</span>
                <span class="stat-value"><?= $reviewCount ?></span>
            </div>
        </div>
    </div>
    
    <div class="user-actions">
        <div class="action-buttons">
            <a href="<?= Url::to(['#']) ?>" class="btn btn-small" title="История бронирований">
                📋 Бронирования
            </a>
            <a href="<?= Url::to(['#']) ?>" class="btn btn-small" title="Отправить сообщение">
                ✉️ Сообщение
            </a>
        </div>
    </div>
</div>

<style>
.user-item-card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    padding: 1.5rem;
    margin-bottom: 1.5rem;
}

.user-header {
    display: flex;
    align-items: center;
    gap: 1.5rem;
    margin-bottom: 1.5rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #eee;
}

.user-avatar {
    width: 60px;
    height: 60px;
    border-radius: 50%;
    background: #f8f9fa;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.user-info {
    flex: 1;
}

.user-name {
    color: #2c3e50;
    margin-bottom: 0.25rem;
    font-size: 1.2rem;
}

.user-meta {
    display: flex;
    flex-direction: column;
    gap: 0.25rem;
}

.user-email {
    color: #555;
    font-size: 0.9rem;
}

.user-login {
    color: #95a5a6;
    font-size: 0.85rem;
}

.admin-badge {
    background: #e74c3c;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}

.user-details {
    margin-bottom: 1.5rem;
}

.detail-row {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
    margin-bottom: 1.5rem;
}

@media (max-width: 768px) {
    .detail-row {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
}

.detail-column h4 {
    color: #2c3e50;
    margin-bottom: 0.75rem;
    font-size: 1rem;
}

.detail-column p {
    margin-bottom: 0.5rem;
    color: #555;
}

.user-stats {
    display: flex;
    gap: 2rem;
    padding: 1rem;
    background: #f8f9fa;
    border-radius: 4px;
}

.stat {
    text-align: center;
}

.stat-label {
    display: block;
    color: #7f8c8d;
    font-size: 0.9rem;
    margin-bottom: 0.25rem;
}

.stat-value {
    font-size: 1.5rem;
    font-weight: bold;
    color: #3498db;
}

.user-actions {
    padding-top: 1rem;
    border-top: 1px solid #eee;
}
</style>