<?php

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ListView;
use app\models\Booking;

$this->title = 'Управление бронированиями';
?>
<div class="admin-bookings">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="admin-filters">
        <div class="filter-tabs">
            <a href="<?= Url::to(['bookings']) ?>" class="filter-tab <?= !Yii::$app->request->get('status') ? 'active' : '' ?>">
                Все (<?= Booking::find()->count() ?>)
            </a>
            <a href="<?= Url::to(['bookings', 'status' => 'new']) ?>" class="filter-tab <?= Yii::$app->request->get('status') == 'new' ? 'active' : '' ?>">
                Новые (<?= Booking::find()->where(['status' => Booking::STATUS_NEW])->count() ?>)
            </a>
            <a href="<?= Url::to(['bookings', 'status' => 'processing']) ?>" class="filter-tab <?= Yii::$app->request->get('status') == 'processing' ? 'active' : '' ?>">
                В процессе (<?= Booking::find()->where(['status' => Booking::STATUS_PROCESSING])->count() ?>)
            </a>
            <a href="<?= Url::to(['bookings', 'status' => 'confirmed']) ?>" class="filter-tab <?= Yii::$app->request->get('status') == 'confirmed' ? 'active' : '' ?>">
                Подтвержденные (<?= Booking::find()->where(['status' => Booking::STATUS_CONFIRMED])->count() ?>)
            </a>
        </div>
    </div>

    <?= ListView::widget([
        'dataProvider' => $dataProvider,
        'itemView' => '_booking_item',
        'layout' => "{summary}\n{items}\n{pager}",
        'summary' => '<div class="summary">Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> бронирований</div>',
        'itemOptions' => ['class' => 'booking-item'],
        'pager' => [
            'options' => ['class' => 'pagination'],
            'linkOptions' => ['class' => 'page-link'],
            'activePageCssClass' => 'active',
            'disabledPageCssClass' => 'disabled',
        ],
    ]) ?>
</div>

<style>
.admin-bookings {
    animation: fadeIn 0.5s ease;
}

.admin-filters {
    margin-bottom: 2rem;
    background: white;
    padding: 1.5rem;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.filter-tabs {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.filter-tab {
    padding: 0.75rem 1.5rem;
    background: #f8f9fa;
    color: #555;
    text-decoration: none;
    border-radius: 4px;
    transition: all 0.3s;
    font-weight: 500;
}

.filter-tab:hover {
    background: #e9ecef;
    color: #2c3e50;
}

.filter-tab.active {
    background: #3498db;
    color: white;
}

.summary {
    color: #7f8c8d;
    margin-bottom: 1rem;
    font-size: 0.9rem;
}

.pagination {
    display: flex;
    gap: 0.5rem;
    list-style: none;
    padding: 2rem 0;
    justify-content: center;
}

.page-link {
    padding: 0.5rem 1rem;
    background: white;
    border: 1px solid #dee2e6;
    color: #3498db;
    text-decoration: none;
    border-radius: 4px;
    transition: all 0.3s;
}

.page-link:hover {
    background: #f8f9fa;
    border-color: #3498db;
}

.page-link.active {
    background: #3498db;
    color: white;
    border-color: #3498db;
}

.page-link.disabled {
    color: #6c757d;
    pointer-events: none;
    background: #f8f9fa;
}
</style>