<?php

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ListView;

$this->title = 'Управление пользователями';
?>
<div class="admin-users">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="admin-search">
        <form method="get" class="search-form">
            <input type="text" name="search" placeholder="Поиск по email, имени или логину..." 
                   value="<?= Html::encode(Yii::$app->request->get('search')) ?>" 
                   class="search-input">
            <button type="submit" class="search-button">🔍</button>
        </form>
    </div>

    <?= ListView::widget([
        'dataProvider' => $dataProvider,
        'itemView' => '_user_item',
        'layout' => "{summary}\n{items}\n{pager}",
        'summary' => '<div class="summary">Показано <b>{begin}-{end}</b> из <b>{totalCount}</b> пользователей</div>',
        'itemOptions' => ['class' => 'user-item'],
        'pager' => [
            'options' => ['class' => 'pagination'],
            'linkOptions' => ['class' => 'page-link'],
            'activePageCssClass' => 'active',
            'disabledPageCssClass' => 'disabled',
        ],
    ]) ?>
</div>

<style>
.admin-users {
    animation: fadeIn 0.5s ease;
}

.admin-search {
    margin-bottom: 2rem;
}

.search-form {
    display: flex;
    max-width: 500px;
}

.search-input {
    flex: 1;
    padding: 0.75rem 1rem;
    border: 1px solid #ddd;
    border-radius: 4px 0 0 4px;
    font-size: 1rem;
}

.search-input:focus {
    outline: none;
    border-color: #3498db;
}

.search-button {
    background: #3498db;
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 0 4px 4px 0;
    cursor: pointer;
    font-size: 1.1rem;
    transition: background 0.3s;
}

.search-button:hover {
    background: #2980b9;
}
</style>