<?php

/* @var $this yii\web\View */
/* @var $dataProvider yii\data\ActiveDataProvider */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Мои заявки';
?>
<div class="booking-index">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="booking-actions">
        <a href="<?= Url::to(['/booking/create']) ?>" class="btn btn-primary">
            Создать новую заявку
        </a>
    </div>

    <?php if ($dataProvider->getTotalCount() > 0): ?>
        <div class="bookings-grid">
            <?php foreach ($dataProvider->getModels() as $booking): ?>
                <div class="booking-card">
                    <div class="booking-header">
                        <h3 class="booking-title">
                            <?= Html::encode($booking->roomType->name) ?>
                        </h3>
                        <span class="booking-status booking-status-<?= $booking->status ?>">
                            <?= $booking->statusLabel ?>
                        </span>
                    </div>
                    
                    <div class="booking-details">
                        <div class="booking-detail">
                            <span class="detail-label">Даты:</span>
                            <span class="detail-value">
                                <?= date('d.m.Y', strtotime($booking->check_in_date)) ?> - 
                                <?= date('d.m.Y', strtotime($booking->check_out_date)) ?>
                                (<?= $booking->nightsCount ?> ночей)
                            </span>
                        </div>
                        
                        <div class="booking-detail">
                            <span class="detail-label">Гости:</span>
                            <span class="detail-value">
                                <?= $booking->adults_count ?> взрослых, <?= $booking->children_count ?> детей
                            </span>
                        </div>
                        
                        <div class="booking-detail">
                            <span class="detail-label">Стоимость:</span>
                            <span class="detail-value"><?= $booking->formattedTotalPrice ?></span>
                        </div>
                        
                        <div class="booking-detail">
                            <span class="detail-label">Способ оплаты:</span>
                            <span class="detail-value"><?= $booking->paymentMethodLabel ?></span>
                        </div>
                        
                        <div class="booking-detail">
                            <span class="detail-label">Дата создания:</span>
                            <span class="detail-value">
                                <?= date('d.m.Y H:i', $booking->created_at) ?>
                            </span>
                        </div>
                    </div>
                    
                    <div class="booking-actions">
                        <a href="<?= Url::to(['view', 'id' => $booking->id]) ?>" class="btn btn-small">
                            Подробнее
                        </a>
                        
                        <?php if ($booking->status === \app\models\Booking::STATUS_NEW || 
                                 $booking->status === \app\models\Booking::STATUS_PROCESSING): ?>
                            <a href="<?= Url::to(['cancel', 'id' => $booking->id]) ?>" 
                               class="btn btn-small btn-danger"
                               onclick="return confirm('Вы уверены, что хотите отменить бронирование?')">
                                Отменить
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($booking->canReview()): ?>
                            <a href="<?= Url::to(['review', 'id' => $booking->id]) ?>" 
                               class="btn btn-small btn-success">
                                Оставить отзыв
                            </a>
                        <?php elseif ($booking->review): ?>
                            <span class="review-badge">Отзыв оставлен</span>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <div class="empty-state">
            <p>У вас пока нет заявок на бронирование.</p>
            <a href="<?= Url::to(['/booking/create']) ?>" class="btn btn-primary">
                Создать первую заявку
            </a>
        </div>
    <?php endif; ?>
</div>

<style>
.booking-index {
    animation: fadeIn 0.5s ease;
}

.booking-actions {
    margin-bottom: 2rem;
}

.bookings-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(350px, 1fr));
    gap: 1.5rem;
}

.booking-card {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    padding: 1.5rem;
    transition: transform 0.3s, box-shadow 0.3s;
}

.booking-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 20px rgba(0,0,0,0.15);
}

.booking-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1rem;
    border-bottom: 1px solid #eee;
    padding-bottom: 1rem;
}

.booking-title {
    margin: 0;
    color: #2c3e50;
    font-size: 1.1rem;
    flex: 1;
}

.booking-status {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
    text-transform: uppercase;
}

.booking-status-new {
    background: #3498db;
    color: white;
}

.booking-status-processing {
    background: #f39c12;
    color: white;
}

.booking-status-confirmed {
    background: #27ae60;
    color: white;
}

.booking-status-cancelled {
    background: #e74c3c;
    color: white;
}

.booking-status-completed {
    background: #7f8c8d;
    color: white;
}

.booking-details {
    margin-bottom: 1.5rem;
}

.booking-detail {
    display: flex;
    margin-bottom: 0.5rem;
    align-items: baseline;
}

.detail-label {
    font-weight: 600;
    color: #555;
    min-width: 120px;
}

.detail-value {
    color: #2c3e50;
    flex: 1;
}

.booking-actions {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.btn-small {
    padding: 0.5rem 1rem;
    font-size: 0.9rem;
}

.btn-danger {
    background: #e74c3c;
    color: white;
}

.btn-danger:hover {
    background: #c0392b;
}

.btn-success {
    background: #27ae60;
    color: white;
}

.btn-success:hover {
    background: #219653;
}

.review-badge {
    background: #95a5a6;
    color: white;
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
}

.empty-state {
    text-align: center;
    padding: 3rem;
    background: #f8f9fa;
    border-radius: 8px;
    border: 2px dashed #ddd;
}

.empty-state p {
    margin-bottom: 1.5rem;
    color: #7f8c8d;
    font-size: 1.1rem;
}

@media (max-width: 768px) {
    .bookings-grid {
        grid-template-columns: 1fr;
    }
    
    .booking-header {
        flex-direction: column;
        gap: 0.5rem;
    }
    
    .booking-detail {
        flex-direction: column;
        gap: 0.25rem;
    }
    
    .detail-label {
        min-width: auto;
    }
}
</style>