<?php

/* @var $this yii\web\View */
/* @var $model app\models\RoomType */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = $model->name;
?>
<div class="room-view">
    <div class="room-header">
        <div class="container">
            <h1 class="page-title"><?= Html::encode($model->name) ?></h1>
            <div class="room-price-badge">
                <span class="price-amount"><?= $model->getFormattedPrice() ?></span>
                <span class="price-period">/ ночь</span>
            </div>
        </div>
    </div>

    <div class="container">
        <div class="room-content">
            <div class="room-main">
                <div class="room-image-section">
                    <div class="room-main-image">
                        <div class="image-placeholder">
                            <span>🏨</span>
                            <p>Изображение номера</p>
                        </div>
                    </div>
                </div>

                <div class="room-description-section">
                    <h2 class="section-title">Описание номера</h2>
                    <p class="room-full-description"><?= nl2br(Html::encode($model->description)) ?></p>
                    
                    <div class="room-details">
                        <div class="detail-item">
                            <div class="detail-icon">👥</div>
                            <div class="detail-content">
                                <h3>Вместимость</h3>
                                <p>До <?= $model->max_guests ?> гостей</p>
                            </div>
                        </div>
                        
                        <div class="detail-item">
                            <div class="detail-icon">🛏️</div>
                            <div class="detail-content">
                                <h3>Тип кровати</h3>
                                <p><?= Html::encode($model->bed_type) ?></p>
                            </div>
                        </div>
                        
                        <div class="detail-item">
                            <div class="detail-icon">📏</div>
                            <div class="detail-content">
                                <h3>Размер номера</h3>
                                <p><?= Html::encode($model->room_size) ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="room-amenities-section">
                    <h2 class="section-title">Удобства и услуги</h2>
                    <div class="amenities-grid">
                        <?php 
                        $amenities = explode(', ', $model->amenities);
                        foreach ($amenities as $amenity): 
                            if (trim($amenity)): ?>
                                <div class="amenity-item">
                                    <span class="amenity-icon">✓</span>
                                    <span class="amenity-text"><?= Html::encode(trim($amenity)) ?></span>
                                </div>
                            <?php endif;
                        endforeach; ?>
                    </div>
                </div>
            </div>

            <div class="room-sidebar">
                <div class="booking-card">
                    <h3 class="booking-title">Забронировать номер</h3>
                    
                    <div class="booking-price">
                        <span class="price-label">Цена за ночь:</span>
                        <span class="price-value"><?= $model->getFormattedPrice() ?></span>
                    </div>
                    
                    <div class="booking-details">
                        <div class="booking-detail">
                            <span class="detail-label">Максимум гостей:</span>
                            <span class="detail-value"><?= $model->max_guests ?></span>
                        </div>
                        <div class="booking-detail">
                            <span class="detail-label">Тип кровати:</span>
                            <span class="detail-value"><?= Html::encode($model->bed_type) ?></span>
                        </div>
                        <div class="booking-detail">
                            <span class="detail-label">Размер номера:</span>
                            <span class="detail-value"><?= Html::encode($model->room_size) ?></span>
                        </div>
                    </div>
                    
                    <?php if (!Yii::$app->user->isGuest): ?>
                        <a href="<?= Url::to(['/booking/create', 'room_type_id' => $model->id]) ?>" 
                           class="btn btn-primary btn-block">
                            Забронировать сейчас
                        </a>
                    <?php else: ?>
                        <div class="booking-login-prompt">
                            <p>Чтобы забронировать номер, необходимо войти в систему</p>
                            <div class="login-buttons">
                                <a href="<?= Url::to(['/site/login']) ?>" class="btn btn-primary">
                                    Войти
                                </a>
                                <a href="<?= Url::to(['/site/register']) ?>" class="btn btn-secondary">
                                    Зарегистрироваться
                                </a>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="booking-note">
                        <p><strong>Примечание:</strong> Бронирование подтверждается после проверки администратором</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="room-navigation">
            <a href="<?= Url::to(['/room/index']) ?>" class="btn btn-outline">
                ← Вернуться к списку номеров
            </a>
        </div>
    </div>
</div>

<style>
.room-view {
    animation: fadeIn 0.5s ease;
}

.room-header {
    background: linear-gradient(135deg, #2c3e50, #34495e);
    color: white;
    padding: 3rem 0;
    margin-bottom: 2rem;
    position: relative;
}

.room-header::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.05)"/></svg>');
    background-size: cover;
}

.room-header .container {
    position: relative;
    z-index: 1;
}

.room-header .page-title {
    margin-bottom: 1rem;
    font-size: 2.5rem;
}

.room-price-badge {
    display: inline-flex;
    align-items: baseline;
    background: rgba(255,255,255,0.2);
    padding: 0.5rem 1.5rem;
    border-radius: 30px;
    backdrop-filter: blur(10px);
}

.price-amount {
    font-size: 2rem;
    font-weight: bold;
}

.price-period {
    font-size: 1rem;
    opacity: 0.9;
    margin-left: 0.5rem;
}

.room-content {
    display: grid;
    grid-template-columns: 1fr 350px;
    gap: 2rem;
}

@media (max-width: 1024px) {
    .room-content {
        grid-template-columns: 1fr;
    }
}

.room-main {
    display: flex;
    flex-direction: column;
    gap: 2rem;
}

.room-image-section {
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
}

.room-main-image {
    height: 400px;
    background: linear-gradient(135deg, #3498db, #2980b9);
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
}

.image-placeholder {
    text-align: center;
}

.image-placeholder span {
    font-size: 6rem;
    display: block;
    margin-bottom: 1rem;
}

.image-placeholder p {
    font-size: 1.2rem;
    opacity: 0.9;
}

.section-title {
    color: #2c3e50;
    margin-bottom: 1.5rem;
    font-size: 1.8rem;
    position: relative;
    padding-bottom: 0.5rem;
}

.section-title::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 60px;
    height: 3px;
    background: #3498db;
    border-radius: 2px;
}

.room-full-description {
    font-size: 1.1rem;
    line-height: 1.8;
    color: #555;
    margin-bottom: 2rem;
}

.room-details {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1.5rem;
}

.detail-item {
    display: flex;
    align-items: flex-start;
    gap: 1rem;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 8px;
    transition: transform 0.3s;
}

.detail-item:hover {
    transform: translateY(-5px);
}

.detail-icon {
    font-size: 2rem;
    min-width: 60px;
    text-align: center;
}

.detail-content h3 {
    color: #2c3e50;
    margin-bottom: 0.5rem;
    font-size: 1.1rem;
}

.detail-content p {
    color: #7f8c8d;
    margin: 0;
}

.room-amenities-section {
    padding: 2rem 0;
}

.amenities-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.amenity-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 0.75rem;
    background: white;
    border-radius: 4px;
    border: 1px solid #e9ecef;
    transition: all 0.3s;
}

.amenity-item:hover {
    background: #f8f9fa;
    border-color: #3498db;
    transform: translateX(5px);
}

.amenity-icon {
    color: #27ae60;
    font-weight: bold;
    font-size: 1.2rem;
}

.amenity-text {
    color: #555;
}

.room-sidebar {
    position: sticky;
    top: 100px;
    height: fit-content;
}

.booking-card {
    background: white;
    border-radius: 8px;
    padding: 2rem;
    box-shadow: 0 4px 20px rgba(0,0,0,0.1);
    border: 1px solid #e9ecef;
}

.booking-title {
    color: #2c3e50;
    margin-bottom: 1.5rem;
    font-size: 1.5rem;
    text-align: center;
}

.booking-price {
    text-align: center;
    margin-bottom: 2rem;
    padding-bottom: 1.5rem;
    border-bottom: 2px solid #f1f1f1;
}

.price-label {
    display: block;
    color: #7f8c8d;
    font-size: 0.9rem;
    margin-bottom: 0.5rem;
}

.price-value {
    font-size: 2.5rem;
    font-weight: bold;
    color: #27ae60;
}

.booking-details {
    margin-bottom: 2rem;
}

.booking-detail {
    display: flex;
    justify-content: space-between;
    margin-bottom: 1rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid #f1f1f1;
}

.booking-detail:last-child {
    border-bottom: none;
    margin-bottom: 0;
    padding-bottom: 0;
}

.detail-label {
    color: #7f8c8d;
}

.detail-value {
    color: #2c3e50;
    font-weight: 500;
}

.btn-block {
    width: 100%;
    padding: 1rem;
    font-size: 1.1rem;
    margin-bottom: 1.5rem;
}

.booking-login-prompt {
    text-align: center;
    padding: 1.5rem;
    background: #f8f9fa;
    border-radius: 4px;
    margin-bottom: 1.5rem;
}

.booking-login-prompt p {
    color: #7f8c8d;
    margin-bottom: 1rem;
}

.login-buttons {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
}

.login-buttons .btn {
    min-width: 120px;
}

.booking-note {
    padding: 1rem;
    background: #fff3cd;
    color: #856404;
    border-radius: 4px;
    font-size: 0.9rem;
    border: 1px solid #ffeaa7;
}

.booking-note p {
    margin: 0;
    line-height: 1.5;
}

.room-navigation {
    margin-top: 3rem;
    padding-top: 2rem;
    border-top: 1px solid #eee;
    text-align: center;
}

.btn-outline {
    background: transparent;
    color: #3498db;
    border: 2px solid #3498db;
    padding: 0.75rem 2rem;
    border-radius: 4px;
    text-decoration: none;
    font-weight: 600;
    transition: all 0.3s;
    display: inline-block;
}

.btn-outline:hover {
    background: #3498db;
    color: white;
    transform: translateY(-2px);
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Анимация появления элементов
    const animateOnScroll = function() {
        const elements = document.querySelectorAll('.detail-item, .amenity-item');
        
        elements.forEach((element, index) => {
            const elementPosition = element.getBoundingClientRect().top;
            const screenPosition = window.innerHeight / 1.2;
            
            if (elementPosition < screenPosition) {
                setTimeout(() => {
                    element.style.opacity = '1';
                    element.style.transform = 'translateY(0)';
                }, index * 100);
            }
        });
    };
    
    // Инициализация анимации
    document.querySelectorAll('.detail-item, .amenity-item').forEach(element => {
        element.style.opacity = '0';
        element.style.transform = 'translateY(20px)';
        element.style.transition = 'opacity 0.5s ease, transform 0.5s ease';
    });
    
    window.addEventListener('scroll', animateOnScroll);
    animateOnScroll(); // Первоначальный вызов
});
</script>