<?php

/* @var $this yii\web\View */
/* @var $model app\models\User */

use yii\helpers\Html;
use yii\helpers\Url;

$this->title = 'Вход в систему';
?>
<div class="login-page">
    <h1 class="page-title"><?= Html::encode($this->title) ?></h1>

    <div class="login-form-container">
        <div class="form-column">
            <form id="login-form" class="auth-form" method="post" action="<?= Url::to(['/site/login']) ?>">
                <input type="hidden" name="<?= Yii::$app->request->csrfParam ?>" value="<?= Yii::$app->request->csrfToken ?>">
                
                <div class="form-group">
                    <label for="user-email" class="form-label">Email *</label>
                    <input type="email" id="user-email" class="form-input" name="User[email]" 
                           value="<?= Html::encode($model->email) ?>" required autofocus>
                    <div class="error-text"><?= Html::error($model, 'email') ?></div>
                </div>
                
                <div class="form-group">
                    <label for="user-password" class="form-label">Пароль *</label>
                    <input type="password" id="user-password" class="form-input" 
                           name="User[password]" required>
                    <div class="error-text"><?= Html::error($model, 'password') ?></div>
                </div>

                <div class="form-group">
                    <button type="submit" class="submit-btn">Войти</button>
                </div>
            </form>
            
            <div class="auth-links">
                <p>Еще не зарегистрированы? <a href="<?= Url::to(['/site/register']) ?>">Зарегистрируйтесь</a></p>
            </div>
        </div>
        
        <div class="info-column">
            <div class="info-card">
                <h3 class="info-title">Для тестирования</h3>
                <div class="test-account">
                    <p><strong>Панель администратора:</strong></p>
                    <div class="account-details">
                        <p>Логин: <code>hotel</code></p>
                        <p>Пароль: <code>hoteladmin</code></p>
                    </div>
                    <p class="test-hint">Или зарегистрируйте свой аккаунт</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.login-page {
    max-width: 800px;
    margin: 0 auto;
    animation: fadeIn 0.5s ease;
}

.login-form-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 2rem;
}

@media (max-width: 768px) {
    .login-form-container {
        grid-template-columns: 1fr;
    }
}

.test-account {
    background: #f8f9fa;
    padding: 1.5rem;
    border-radius: 6px;
    border-left: 4px solid #3498db;
}

.account-details {
    margin: 1rem 0;
}

.account-details code {
    background: #e8f4fc;
    padding: 0.2rem 0.5rem;
    border-radius: 3px;
    font-family: monospace;
    color: #2c3e50;
}

.test-hint {
    font-size: 0.9rem;
    color: #7f8c8d;
    font-style: italic;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('login-form');
    
    form.addEventListener('submit', function(e) {
        // Сброс предыдущих ошибок
        document.querySelectorAll('.error-text').forEach(el => el.textContent = '');
        document.querySelectorAll('.form-input').forEach(el => el.classList.remove('error'));
        
        const email = document.getElementById('user-email').value;
        const password = document.getElementById('user-password').value;
        
        if (!email || !password) {
            e.preventDefault();
            if (!email) {
                const errorEl = document.querySelector('[data-error="email"]');
                if (errorEl) errorEl.textContent = 'Email обязателен';
            }
            if (!password) {
                const errorEl = document.querySelector('[data-error="password"]');
                if (errorEl) errorEl.textContent = 'Пароль обязателен';
            }
            return;
        }
    });
});
</script>